package MusicLandscape.util.comparators;

import MusicLandscape.entities.Event;

/**
 * This class represents the concept of comparison of two events. It has a single abstract method that is to be
 * implemented by concrete subclasses which implement concrete modes of comparison, e.g. by attendees, by date or other.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 1
 * @since ExerciseSheet04
 */
public class MyEventDateComparator extends MyEventComparator {
    /**
     * Compare two events by their dates.
     *
     * @param e1 the one event to compare
     * @param e2 the other event to compare
     * @return a measure of the distance between e1 and e2 in the sense of the comparator
     */
    @Override
    public int compare(Event e1, Event e2) {
        if (e1 == null && e2 == null || e1 != null && e1.getDate() == null && e2 != null && e2.getDate() == null) {
            return 0;
        }
        if (e1 == null) {
            return -1;
        }
        if (e2 == null) {
            return 1;
        }
        if (e1.getDate() == null) {
            return -1;
        }
        if (e2.getDate() == null) {
            return 1;
        }

        return e1.getDate().julianDayNumber() - e2.getDate().julianDayNumber();
    }
}
